#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
#endregion

namespace GroundhogLearning.GameKit
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_TRANSFORMS + "Mover")]
    public class Mover : MonoBehaviour
    {
        #region Variables

        [Header("Configuration")]
        [SerializeField, Tooltip("If true, movement begins automatically when the scene starts.")]
        private bool _autoStart = true;

        [SerializeField, Tooltip("Axis along which the object will move (X, Y, Z).")]
        private Vector3 _moveAxis = Vector3.forward;

        [SerializeField, Tooltip("Movement speed in units per second.")]
        private float _moveSpeed = 2f;

        private bool _isMoving;
        private bool _goingForward = true;
        private Vector3 _startPosition;
        private float _pauseTimer;

        #endregion

        private void Start()
        {
            _startPosition = transform.position;

            if (_autoStart)
            {
                _isMoving = true;
            }
        }
        private void Update()
        {
            if (!_isMoving) return;
            Move();
        }

        private void Move()
        {
            var direction = _moveAxis.normalized * (_goingForward ? 1f : -1f);
            transform.Translate(direction * _moveSpeed * Time.deltaTime, Space.World);
        }

        public void StartMoving() => _isMoving = true;
        public void StopMoving() => _isMoving = false;

#if UNITY_EDITOR
        private void OnDrawGizmosSelected()
        {
            Gizmos.color = Color.cyan;
            Vector3 start = Application.isPlaying ? _startPosition : transform.position;
            Vector3 end = start + _moveAxis.normalized * 1;
            Gizmos.DrawLine(start, end);
            Gizmos.DrawSphere(end, 0.1f);
        }
#endif
    }
}
